<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('password');

    public function role()
    {
        return $this->hasOne('App\Models\Role', 'role_id', 'id');
    }

    public function projects()
    {
        return $this->hasManyThrough('App\Models\Project\Project', 'UserProject', 'user_id', 'id');
    }

    public function tasks()
    {
        return $this->belongsToMany('App\Models\Task');
    }

    public function files()
    {
        return $this->morphMany('App\Models\File', 'model');
    }

    public function vaults()
    {
        return $this->belongsToMany('App\Models\Vault', 'user_vaults', 'user_id', 'vault_id');
    }

}